<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Models\Sku;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class InventoryController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:inventory-summary', ['only' => ['index']]);
    }
    
    public function index(Request $request){
        if($request->ajax()){
            $records=Sku::groupBy('group_id')
                            ->join('type_images','type_images.code','=','product_info.group_id')
                            ->select(['product_name','prod_img','product_url','group_id','type_images.image']);
            $columns = array( 0 =>'productDetail');
            $totalData = Sku::groupBy('group_id')->count();
            $totalFiltered = $totalData; 
            $limit = $request->input('length');
            $start = $request->input('start');
            // $order = $columns[$request->input('order.0.column')];
            // $dir = $request->input('order.0.dir');
            
            if(empty($request->input('search.value'))){            
                $skus = Sku::groupBy('group_id');
                            // ->offset($start)
                            // ->limit($limit)
                        //  ->orderBy($order,$dir);
                        //  ->get();
            }else {
                $search = $request->input('search.value'); 

                $skus =  Sku::where('product_name','LIKE',"%{$search}%")
                            
                            ->groupBy('group_id');
                            // ->offset($start)
                            // ->limit($limit)
                            // ->orderBy($order,$dir);
                            // ->get();

                $totalFiltered = Sku::where('product_name','LIKE',"%{$search}%")
                             ->groupBy('group_id')
                             ->count();
            }
            
            if($limit !='-1'){
                $skus->offset($start)->limit($limit);
            }
            
            
            
            $data = array();
            $product_size=DB::table('product_size')->where('status',1)->get();
            if(!empty($skus->get())){
                foreach ($skus->get() as $sku){
                    $nestedData=array();
                    $total=0;
                    if($sku->product_url !=''){
                        $url=$sku->product_url;
                        $img=' <img src="'.$sku->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">';
                    }else{
                        $url=asset('uploads/sku_images/'.$sku->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$sku->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">';
                    }
                    $sp=explode(",",$sku->product_name);
                    $nestedData['productDetail']='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-8">
                                '.'<strong>'.$sp[0].'</strong>'.'<br>
                                <span class="text-success">SKU : <strong>'.$sku->group_id.'</strong></span><br>
                            </div>
                        </div>';
                    foreach($product_size as $ps){
                        $check=Sku::where([
                                    'group_id' => $sku->group_id,
                                    'prod_size' => $ps->id,
                                ])->first();
                        
                        if($check !==null){
                            $qty=$check->Quantity;
                        }else{
                            $qty=0;
                        }
                        $total+=$qty;
                        $nestedData[$ps->size]=$qty;
                    }
                    
                    $nestedData['total']=$total;
                    $data[] = $nestedData;
    
                }
            }
            
            $json_data = array(
                "draw"            => intval($request->input('draw')),  
                "recordsTotal"    => intval($totalData),  
                "recordsFiltered" => intval($totalFiltered), 
                "data"            => $data   
                );
            echo json_encode($json_data);
        }else{
            $product_size=DB::table('product_size')->where('status',1)->get();
            return view('inventory.index',['product_sizes' => $product_size]);
        }
    }
}
